import { Currency, Price } from '@uniswap/sdk-core';
import { TPool } from '../../utils/TPool';
/**
 * Represents a list of pools or pairs through which a swap can occur
 * @template TInput The input token
 * @template TOutput The output token
 */
export declare class MixedRouteSDK<TInput extends Currency, TOutput extends Currency> {
    readonly pools: TPool[];
    readonly path: Currency[];
    readonly input: TInput;
    readonly output: TOutput;
    readonly pathInput: Currency;
    readonly pathOutput: Currency;
    private _midPrice;
    /**
     * Creates an instance of route.
     * @param pools An array of `TPool` objects (pools or pairs), ordered by the route the swap will take
     * @param input The input token
     * @param output The output token
     * @param retainsFakePool Set to true to filter out a pool that has a fake eth-weth pool
     */
    constructor(pools: TPool[], input: TInput, output: TOutput, retainFakePools?: boolean);
    get chainId(): number;
    /**
     * Returns the mid price of the route
     */
    get midPrice(): Price<TInput, TOutput>;
}
